import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:adult_axolotl', {
        onUseOn({ source, block, blockFace }) {
            const { x, y, z } = block.location
            const selectedItem = source.getComponent('equippable').getEquipment('Mainhand')
            if (blockFace === 'Up' && (block.above().isAir || block.above().typeId === 'minecraft:water' || block.above().typeId === 'minecraft:flowing_water')) {
                block.above().setType('flowing_water')
                block.above().dimension.runCommand(`summon v360:green_axolotl ${x} ${y + 1} ${z} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'Down' && (block.below().isAir || block.below().typeId === 'minecraft:water' || block.below().typeId === 'minecraft:flowing_water')) {
                block.below().setType('flowing_water')
                block.below().dimension.runCommand(`summon v360:green_axolotl ${x} ${y - 1} ${z} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'North' && (block.north().isAir || block.north().typeId === 'minecraft:water' || block.north().typeId === 'minecraft:flowing_water')) {
                block.north().setType('flowing_water')
                block.north().dimension.runCommand(`summon v360:green_axolotl ${x} ${y} ${z - 1} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'South' && (block.south().isAir || block.south().typeId === 'minecraft:water' || block.south().typeId === 'minecraft:flowing_water')) {
                block.south().setType('flowing_water')
                block.south().dimension.runCommand(`summon v360:green_axolotl ${x} ${y} ${z + 1} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'West' && (block.west().isAir || block.west().typeId === 'minecraft:water' || block.west().typeId === 'minecraft:flowing_water')) {
                block.west().setType('flowing_water')
                block.west().dimension.runCommand(`summon v360:green_axolotl ${x - 1} ${y} ${z} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'East' && (block.east().isAir || block.east().typeId === 'minecraft:water' || block.east().typeId === 'minecraft:flowing_water')) {
                block.east().setType('flowing_water')
                block.east().dimension.runCommand(`summon v360:green_axolotl ${x + 1} ${y} ${z} ~~ axolotl_green_adult`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:baby_axolotl', {
        onUseOn({ source, block, blockFace }) {
            const { x, y, z } = block.location
            const selectedItem = source.getComponent('equippable').getEquipment('Mainhand')
            if (blockFace === 'Up' && (block.above().isAir || block.above().typeId === 'minecraft:water' || block.above().typeId === 'minecraft:flowing_water')) {
                block.above().setType('flowing_water')
                block.above().dimension.runCommand(`summon v360:green_axolotl ${x} ${y + 1} ${z} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'Down' && (block.below().isAir || block.below().typeId === 'minecraft:water' || block.below().typeId === 'minecraft:flowing_water')) {
                block.below().setType('flowing_water')
                block.below().dimension.runCommand(`summon v360:green_axolotl ${x} ${y - 1} ${z} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'North' && (block.north().isAir || block.north().typeId === 'minecraft:water' || block.north().typeId === 'minecraft:flowing_water')) {
                block.north().setType('flowing_water')
                block.north().dimension.runCommand(`summon v360:green_axolotl ${x} ${y} ${z - 1} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'South' && (block.south().isAir || block.south().typeId === 'minecraft:water' || block.south().typeId === 'minecraft:flowing_water')) {
                block.south().setType('flowing_water')
                block.south().dimension.runCommand(`summon v360:green_axolotl ${x} ${y} ${z + 1} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'West' && (block.west().isAir || block.west().typeId === 'minecraft:water' || block.west().typeId === 'minecraft:flowing_water')) {
                block.west().setType('flowing_water')
                block.west().dimension.runCommand(`summon v360:green_axolotl ${x - 1} ${y} ${z} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
            else if (blockFace === 'East' && (block.east().isAir || block.east().typeId === 'minecraft:water' || block.east().typeId === 'minecraft:flowing_water')) {
                block.east().setType('flowing_water')
                block.east().dimension.runCommand(`summon v360:green_axolotl ${x + 1} ${y} ${z} ~~ axolotl_green_baby`)
                block.dimension.playSound('bucket.empty_fish', block.location)
                if (source.getGameMode() !== 'creative') {
                    source.getComponent('equippable').setEquipment('Mainhand', new ItemStack('bucket', 1))
                }
            }
        }
    })
})